<?php

/**
 * uninstall.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

// initialize plugin
include dirname(__FILE__).'/kocuj-sitemap.php';
\KocujSitemapPlugin\Classes\Base::getInstance()->init();
// purge cache
try {
	\KocujSitemapPlugin\Classes\Cache::getInstance()->clearCache(true);
} catch (Exception $e) {
}
// uninstall plugin
\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getComponent('backend', 'plugin-uninstall');
