<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V6a\Classes\Project\Components\Backend\VersionCheck;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Version check (component initialization) class
 *
 * @access public
 */
class Init extends \KocujIL\V6a\Classes\ComponentInitObject {
	/**
	 * Required components
	 *
	 * @access protected
	 * @var array
	 */
	protected $requiredComponents = array(
		'' => array(
			'all' => array(
				'js-ajax',
			),
		),
	);

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujIL\V6a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add actions
		$this->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('admin_init', 'backend', 'version-check', '', 'actionAdminInit', \KocujIL\V6a\Classes\Helper::getInstance()->calculateMaxPriority('admin_init'));
		$this->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('admin_print_footer_scripts', 'backend', 'version-check', '', 'actionPrintFooterScripts', \KocujIL\V6a\Classes\Helper::getInstance()->calculateMaxPriority('admin_print_footer_scripts'));
		// add actions for AJAX
		if ((current_user_can('manage_network')) || (current_user_can('manage_options'))) {
			$this->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('wp_ajax_'.$this->getComponent('core', 'project-helper')->getPrefix().'__version_check_display', 'backend', 'version-check', 'ajax', 'actionAjaxDisplay');
		}
	}
}
