<?php

/**
 * ajax.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V6a\Classes\Project\Components\Backend\AddThanks;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks AJAX class
 *
 * @access public
 */
class Ajax extends \KocujIL\V6a\Classes\ComponentObject {
	/**
	 * Action for set that adding thanks has been finished
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxFinished() {
		// check AJAX nonce
		check_ajax_referer(\KocujPlLib\V6a\Classes\Helper::getInstance()->getPrefix().'__add_thanks', 'security');
		// set that adding thanks has been finished
		$this->getProjectObj()->getProjectKocujILObj()->get('core', 'meta')->addOrUpdate($this->getComponent('backend', 'add-thanks')->OPTION_NAME_THANKS_ADDED, '1');
		// close connection
		wp_die();
	}

	/**
	 * Action for displaying more information about adding thanks in window
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxMoreInfoWindowDisplay() {
		// check AJAX nonce
		check_ajax_referer(\KocujPlLib\V6a\Classes\Helper::getInstance()->getPrefix().'__add_thanks', 'security');
		// get list of websites where website address can be displayed
		$websites = array_merge(array(
			\KocujPlLib\V6a\Classes\Helper::getInstance()->getKocujPlUrl(false),
		), $this->getProjectObj()->getSettingArray('additionalwebsites'));
		$websitesString = '';
		$loopCount = count($websites);
		for ($z=0; $z<$loopCount; $z++) {
			if ($z > 0) {
				$websitesString .= (($z < $loopCount-1) ?
					', ' :
					' '.$this->getStrings('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_WEBSITES_AND').' ');
			}
			$websitesString .= '<strong>'.$websites[$z].'</strong>';
		}
		// show more information about adding thanks
		printf($this->getStrings('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_1'), $websitesString);
		echo '<br /><br />';
		echo $this->getStrings('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_2');
		echo '<br /><br />';
		echo $this->getStrings('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_3');
		echo '<ul style="list-style:disc;margin-left:15px;">';
		echo '<li>';
		echo $this->getStrings('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_4');
		echo '</li><li>';
		echo $this->getStrings('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_5');
		echo '</li><li>';
		echo $this->getStrings('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_6');
		echo '</li>';
		echo '</ul>';
		echo $this->getStrings('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_7');
		echo '<br /><br />';
		echo $this->getStrings('backend', 'add-thanks')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_8');
		// close connection
		wp_die();
	}
}
