<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V6a\Classes\Project\Components\Backend\SettingsMetaBoxes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Meta boxes for settings (component initialization) class
 *
 * @access public
 */
class Init extends \KocujIL\V6a\Classes\ComponentInitObject {
	/**
	 * Required components
	 *
	 * @access protected
	 * @var array
	 */
	protected $requiredComponents = array(
		'' => array(
			'backend' => array(
				'settings-menu',
			),
		),
	);

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujIL\V6a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add actions
		$this->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('admin_enqueue_scripts', 'backend', 'settings-meta-boxes', '', 'actionEnqueueScripts', 10);
		$this->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded($this->getComponent('core', 'project-helper')->getPrefix().'__after_wrapinside_div', 'backend', 'settings-meta-boxes', '', 'actionAfterFormDiv');
		// add filters
		$this->getComponent('core', 'actions-filters-helper')->addFilterWhenNeeded($this->getComponent('core', 'project-helper')->getPrefix().'__wrapinside_div_style', 'backend', 'settings-meta-boxes', '', 'filterFormDivStyle');
	}
}
