<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V6a\Classes\Project\Components\Backend\InstallationDate;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Installation date class
 *
 * @access public
 */
class Component extends \KocujIL\V6a\Classes\ComponentObject {
	/**
	 * Option name - installation date
	 *
	 */
	const OPTION_NAME_INSTALL_DATE = 'install_date';

	/**
	 * Get installation date from database
	 *
	 * @access public
	 * @return string Installation date from database
	 */
	public function getInstallationDateOptionValue() {
		// exit
		return $this->getComponent('core', 'meta')->get(self::OPTION_NAME_INSTALL_DATE);
	}
}
