<?php

/**
 * admin.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\KocujILStrings\All;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * \KocujIL\V7a\Classes\Project\Components\All\Admin classes strings
 *
 * @access public
 */
class Admin implements \KocujIL\V7a\Interfaces\Strings {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get string
	 *
	 * @access public
	 * @param string $id String id
	 * @return string Output string
	 */
	public function getString($id) {
		// get string
		$texts = array(
			'INIT_SETTINGS_SAVED'                  => __('Settings saved.', 'kocuj-sitemap'),
			'INIT_DATA_SAVED'                      => __('Data saved.', 'kocuj-sitemap'),
			'INIT_SETTINGS_RESET'                  => __('Settings reset.', 'kocuj-sitemap'),
			'INIT_SETTINGS_UNINSTALLED'            => __('Settings has been uninstalled.', 'kocuj-sitemap'),
			'INPUT_HELPER_RESET_CONFIRM'           => __('Are you sure do you want to restore default settings?', 'kocuj-sitemap'),
			'INPUT_HELPER_UNINSTALL_CONFIRM'       => __('Are you sure do you want to uninstall settings?', 'kocuj-sitemap'),
			'GET_BLOCK_HELPER_ADD_NEW_ELEMENT'     => __('add new element', 'kocuj-sitemap'),
			'PAGE_CONTROLLER_UNKNOWN_FORM_ERROR'   => __('Unknown form error.', 'kocuj-sitemap'),
			'PAGE_CONTROLLER_WRONG_PARAMETERS'     => __('Wrong parameters.', 'kocuj-sitemap'),
			'CONTROLLER_SAVE_EXTERNAL_FORM_ERRORS' => __('There were some errors in the form.', 'kocuj-sitemap'),
			'CONTROLLER_SAVE_EXTERNAL_DATA_ERRORS' => __('There were some errors during saving data.', 'kocuj-sitemap'),
			'PROCESS_OUTPUT_ERRORS'                => __('There were some errors. Options with these problems have not been saved.', 'kocuj-sitemap'),
		);
		// exit
		return (isset($texts[$id])) ?
			$texts[$id] :
			'';
	}
}
