<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujPlLib\V7a\Classes\Project\Components\Backend\AddThanks;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks (component initialization) class
 *
 * @access public
 */
class Init extends \KocujIL\V7a\Classes\ComponentInitObject {
	/**
	 * Required components
	 *
	 * @access protected
	 * @var array
	 */
	protected $requiredComponents = array(
		'KocujIL' => array(
			'all' => array(
				'js-ajax',
			),
		),
	);

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujIL\V7a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add actions
		if ((!\KocujIL\V7a\Classes\Helper::getInstance()->checkUserIPLocal()) && ((current_user_can('manage_network_plugins')) || (current_user_can('activate_plugins')) || (current_user_can('install_plugins')))) {
			$this->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('admin_footer', 'backend', 'add-thanks', '', 'actionAdminFooter', 1);
		}
		// add actions for AJAX
		if ((!\KocujIL\V7a\Classes\Helper::getInstance()->checkUserIPLocal()) && ((current_user_can('manage_network_plugins')) || (current_user_can('activate_plugins')) || (current_user_can('install_plugins')))) {
			$this->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('wp_ajax_'.$this->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_finished', 'backend', 'add-thanks', 'ajax', 'actionAjaxFinished');
			$this->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('wp_ajax_'.$this->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_more_info_window_display', 'backend', 'add-thanks', 'ajax', 'actionAjaxMoreInfoWindowDisplay');
		}
	}
}
