<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V7a\Classes\Project\Components\Backend\SettingsAdvMetaBoxes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Settings advertisements meta boxes class
 *
 * @access public
 */
class Component extends \KocujIL\V7a\Classes\ComponentObject {
	/**
	 * Show author information (true) or not (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $authorInfo = false;

	/**
	 * Languages for author information
	 *
	 * @access private
	 * @var array
	 */
	private $authorInfoLanguages = array();

	/**
	 * Set author information to display
	 *
	 * @access public
	 * @param array $languages Set languages in which this information will be displayed; if empty, this information will be displayed in all languages - default: empty
	 * @return void
	 */
	public function setAuthorInfo(array $languages = array()) {
		// set author information to display
		$this->authorInfo = true;
		$this->authorInfoLanguages = $languages;
	}

	/**
	 * Action for adding information
	 *
	 * @access public
	 * @return void
	 */
	public function actionAdminInit() {
		// get locale
		$locale = get_locale();
		// show author information
		if (($this->authorInfo) && ((empty($this->authorInfoLanguages)) || (in_array($locale, $this->authorInfoLanguages)))) {
			$this->getProjectObj()->getProjectKocujILObj()->get('backend', 'settings-meta-boxes')->addSettingsMetaBox(\KocujPlLib\V7a\Classes\Helper::getInstance()->getPrefix().'_author', $this->getStrings('backend', 'settings-adv-meta-boxes')->getString('ACTION_ADMIN_INIT_META_BOX_AUTHOR_TITLE'), sprintf($this->getStrings('backend', 'settings-adv-meta-boxes')->getString('ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_1'), \KocujIL\V7a\Classes\HtmlHelper::getInstance()->getLink(\KocujPlLib\V7a\Classes\Helper::getInstance()->getKocujPlUrl(true), \KocujPlLib\V7a\Classes\Helper::getInstance()->getKocujPlUrl(false), array(
					'external' => true,
				))).
				'<br /><br />'.
				'<strong>'.sprintf($this->getStrings('backend', 'settings-adv-meta-boxes')->getString('ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_2'), \KocujPlLib\V7a\Classes\Helper::getInstance()->getKocujPlUrl(false)).'</strong>'.
				'<ul style="list-style:disc;margin-left:15px;">'.
				'<li>'.$this->getStrings('backend', 'settings-adv-meta-boxes')->getString('ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_3').'</li>'.
				'<li>'.$this->getStrings('backend', 'settings-adv-meta-boxes')->getString('ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_4').'</li>'.
				'<li>'.$this->getStrings('backend', 'settings-adv-meta-boxes')->getString('ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_5').'</li>'.
				'<li>'.$this->getStrings('backend', 'settings-adv-meta-boxes')->getString('ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_6').'</li>'.
				'<li>'.$this->getStrings('backend', 'settings-adv-meta-boxes')->getString('ACTION_ADMIN_INIT_META_BOX_AUTHOR_TEXT_7').'</li>'.
				'</ul>');
		}
	}
}
