/**
 * @file Exceptions handler
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj <dominik@kocuj.pl>
 */

(function() {})(); // empty function for correct minify with comments
//'use strict'; // for jshint uncomment this and comment line above

/* jshint strict: true */
/* jshint -W034 */

/* global kocujILV7aHelper */

/* global kocujILV7aExceptionCode */

/**
 * Exception prototype constructor
 *
 * @constructs
 * @namespace kocujILV7aCException
 * @public
 * @param {number} [code] Error code
 * @param {string} [filename] Filename with error
 * @param {string} [param] Parameter for error information
 * @return {void}
 */
function kocujILV7aCException(code, filename, param) {
	'use strict';
	/* jshint validthis: true */
	// get this object
	var self = this;
	// parse arguments
	code = kocujILV7aHelper.initNumeric(code);
	filename = kocujILV7aHelper.initString(filename);
	if (filename === '') {
		filename = 'unknown';
	}
	param = kocujILV7aHelper.initString(param);
	// set errors
	self._setErrors();
	// prepare message
	var msg = '[' + self._getExceptionName() + '] [file: ' + filename + '] ';
	if (self._errors[code] !== undefined) {
		msg += self._errors[code];
	} else {
		msg += 'Unknown error';
	}
	if (param !== '') {
		msg += ' (' + param + ')';
	}
	// set message
	self.message = msg;
}

// exception prototype
kocujILV7aCException.prototype = new Error();
kocujILV7aCException.prototype.constructor = kocujILV7aCException;

// errors
kocujILV7aCException.prototype._errors = [];

/**
 * Get errors list
 *
 * @public
 * @return {Array} List of errors where keys are errors codes and values are errors texts
 */
kocujILV7aCException.prototype.getErrors = function() {
	'use strict';
	// exit
	return this._errors;
};

/**
 * Get exception name
 *
 * @private
 * @return {string} Exception name
 */
kocujILV7aCException.prototype._getExceptionName = function() {
	'use strict';
	// exit
	return 'kocujilv7a';
};

/**
 * Set errors codes and texts
 *
 * @private
 * @return {void}
 */
kocujILV7aCException.prototype._setErrors = function() {
	'use strict';
	// set errors
	var codes = kocujILV7aExceptionCode;
	this._errors[codes.OK] = 'OK';
	this._errors[codes.EMPTY_PROJECT_ID] = 'Empty project identifier';
	this._errors[codes.PROJECT_DOES_NOT_EXIST] = 'Project does not exist';
	this._errors[codes.PROJECT_ALREADY_EXISTS] = 'Project already exists';
	this._errors[codes.EMPTY_ELEMENT_PATH] = 'Empty element path';
	this._errors[codes.ELEMENT_DOES_NOT_EXIST] = 'Element does not exist';
	this._errors[codes.JS_AJAX_EMPTY_URL] = 'Empty URL for AJAX script';
	this._errors[codes.JS_AJAX_EMPTY_METHOD] = 'Empty method for AJAX script';
	this._errors[codes.JS_AJAX_EMPTY_DATA_TYPE] = 'Empty data type for AJAX script';
	this._errors[codes.MODAL_WINDOW_HAS_BEEN_PREPARED_ALREADY] = 'Modal window has been prepared already';
	this._errors[codes.MODAL_WINDOW_HAS_NOT_BEEN_PREPARED] = 'Modal window has not been prepared';
	this._errors[codes.MODAL_WINDOW_WRONG_TYPE] = 'Wrong type of modal window';
	this._errors[codes.MODAL_WINDOW_WRONG_WIDTH] = 'Wrong width of modal window';
	this._errors[codes.MODAL_WINDOW_WRONG_HEIGHT] = 'Wrong height of modal window';
	this._errors[codes.MODAL_WINDOW_WRONG_OPACITY] = 'Wrong opacity of modal window';
	this._errors[codes.MODAL_WINDOW_VISIBLE] = 'Modal window is visible';
	this._errors[codes.MODAL_WINDOW_CLOSE_EVENT_EXISTS_ALREADY] = 'Close event for modal window exists already';
	this._errors[codes.MODAL_WINDOW_CLOSE_EVENT_DOES_NOT_EXIST] = 'Close event for modal window does not exist';
	this._errors[codes.VERSION_CHECK_WRONG_PROJECT_TYPE] = 'Wrong project type for version check script';
	this._errors[codes.VERSION_CHECK_EMPTY_PROJECT_NAME] = 'Empty project name for version check script';
	this._errors[codes.VERSION_CHECK_EMPTY_VERSION_FROM] = 'Empty version from for version check script';
	this._errors[codes.VERSION_CHECK_EMPTY_VERSION_TO] = 'Empty version to for version check script';
};
