<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V7a\Classes\Project\Components\Backend\PageAboutAddThanks;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks from page about class
 *
 * @access public
 */
class Component extends \KocujIL\V7a\Classes\ComponentObject {
	/**
	 * Page about with adding thanks is set to be displayed (true) or page about with adding thanks will not be displayed (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $pageAboutAddThanksDisplay = false;

	/**
	 * Action for displaying adding thanks button in page about
	 *
	 * @access public
	 * @return void
	 */
	public function actionAfterPageAbout() {
		// check if thanks has not been added already
		if ($this->getComponent('backend', 'add-thanks')->getThanksAddedOptionValue()) {
			return;
		}
		// show adding thanks
		echo '<div id="'.esc_attr($this->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_page_about_div').'">';
		echo '<hr />';
		echo '<br />';
		if ($this->getProjectObj()->getProjectKocujILObj()->getMainSettingType() === \KocujIL\V7a\Enums\ProjectType::PLUGIN) {
			echo $this->getStrings('backend', 'page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_TEXT_PLUGIN');
		} else {
			echo $this->getStrings('backend', 'page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_TEXT_THEME');
		}
		echo ' ';
		printf($this->getStrings('backend', 'page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_TEXT'), \KocujIL\V7a\Classes\HtmlHelper::getInstance()->getLinkBegin('#', array(
			'id' => $this->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_page_about_more_info_link',
		)), \KocujIL\V7a\Classes\HtmlHelper::getInstance()->getLinkEnd());
		echo '<br /><br />';
		echo '<input type="button" class="button button-small" id="'.esc_attr($this->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_page_about_send').'" value="'.$this->getStrings('backend', 'page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_ADD_THANKS').'" />';
		echo '<br />';
		echo '<div id="'.esc_attr($this->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_page_about_status_div').'" style="display:none;">&nbsp;</div>';
		echo '<div id="'.esc_attr($this->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_page_about_loading_div').'" style="display:none;">';
		echo \KocujIL\V7a\Classes\HtmlHelper::getInstance()->getImage(\KocujPlLib\V7a\Classes\LibUrls::getInstance()->get('images').'/project/components/backend/page-about-add-thanks/loading.gif');
		echo '</div>';
		echo '</div>';
		// add scripts
		$this->getComponent('backend', 'add-thanks')->setAddThanksDisplay(true);
		// set page about with adding thanks to be displayed
		$this->pageAboutAddThanksDisplay = true;
	}

	/**
	 * Action for scripts
	 *
	 * @access public
	 * @return void
	 */
	public function actionPrintFooterScripts() {
		// initialize page about script
		if ($this->pageAboutAddThanksDisplay) {
			?>
				<script type="text/javascript">
				/* <![CDATA[ */
					(function($) {
						$(document).ready(function() {
							kocujPLV7aBackendAddThanks.addProjectIfNotExists('<?php echo esc_js($this->getProjectObj()->getProjectKocujILObj()->getMainSettingInternalName()); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'url')); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'login')); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'password')); ?>');
							kocujPLV7aBackendAddThanks.setPageAboutAddThanks('<?php echo esc_js($this->getProjectObj()->getProjectKocujILObj()->getMainSettingInternalName()); ?>');
						});
					}(jQuery));
				/* ]]> */
				</script>
			<?php
		}
	}
}
