<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016-2017 kocuj.pl
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V9a\Classes\Project\Components\Backend\InstallationDate;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Installation date (component initialization) class
 *
 * @access public
 */
class Init extends \KocujIL\V9a\Classes\ComponentInitObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujIL\V9a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// optionally create installation date
		$value = $this->getComponent('installation-date', \KocujIL\V9a\Enums\ProjectCategory::BACKEND)->getInstallationDateOptionValue();
		if ($value === false) {
			$this->getComponent('meta')->addOrUpdate(Component::getOptionNameInstallDate(), date('Y-m-d'));
		}
	}
}
